/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui;

import com.aptana.ui.MenuDialogItem;
import com.aptana.ui.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.progress.UIJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickMenuDialog
extends PopupDialog {
    private static final String MNEMONIC = "mnemonic";
    private static final String INDEX = "index";
    private static final String IS_SEPARATOR = "isSeparator";
    private static final String MNEMONICS = "123456789";
    private Table fTable;
    private List<MenuDialogItem> menuItems = new ArrayList<MenuDialogItem>();

    public QuickMenuDialog(Shell parent) {
        this(parent, null);
    }

    public QuickMenuDialog(Shell parent, String title) {
        super(parent, 4, true, false, false, false, false, title, null);
    }

    public void setInput(List<MenuDialogItem> items) {
        this.menuItems = items;
    }

    protected final Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.marginHeight = 0;
        compositeLayout.marginWidth = 0;
        composite.setLayout((Layout)compositeLayout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setBackground(parent.getBackground());
        if (this.menuItems.isEmpty()) {
            this.createEmptyDialogArea(composite);
        } else {
            this.createTableDialogArea(composite, this.menuItems);
        }
        return composite;
    }

    protected Point getInitialLocation(Point initialSize) {
        Display display = this.getShell().getDisplay();
        if (display != null && !display.isDisposed()) {
            return display.getCursorLocation();
        }
        return super.getInitialLocation(initialSize);
    }

    protected Color getBackground() {
        return this.getShell().getDisplay().getSystemColor(22);
    }

    private final void createEmptyDialogArea(Composite parent) {
        Label noMatchesLabel = new Label(parent, 0);
        noMatchesLabel.setText(Messages.QuickMenuDialog_NoMatchesFound);
        noMatchesLabel.setLayoutData((Object)new GridData(1808));
        noMatchesLabel.setBackground(parent.getBackground());
    }

    private final void createTableDialogArea(Composite parent, List<MenuDialogItem> partialMatches) {
        this.fTable = new Table(parent, 65540);
        GridData gridData = new GridData(1808);
        this.fTable.setLayoutData((Object)gridData);
        this.fTable.setBackground(parent.getBackground());
        this.fTable.setLinesVisible(false);
        ArrayList<TableColumn> columns = new ArrayList<TableColumn>();
        int mnemonic = 0;
        int index = -1;
        columns.add(new TableColumn(this.fTable, 16384, 0));
        columns.add(new TableColumn(this.fTable, 16384, 1));
        columns.add(new TableColumn(this.fTable, 0x1000000, 2));
        for (MenuDialogItem item : partialMatches) {
            ++index;
            if (item.isSeparator()) {
                this.insertSeparator(3);
                continue;
            }
            TableItem tableItem = new TableItem(this.fTable, 0);
            Image image = item.getImage();
            if (image != null) {
                tableItem.setImage(0, image);
            }
            tableItem.setText(1, item.getText());
            tableItem.setData(MNEMONIC, (Object)mnemonic);
            tableItem.setText(2, mnemonic < MNEMONICS.length() ? String.valueOf(MNEMONICS.charAt(mnemonic++)) : "");
            tableItem.setData(INDEX, (Object)index);
        }
        Dialog.applyDialogFont((Control)parent);
        for (TableColumn tableColumn : columns) {
            tableColumn.pack();
        }
        this.fTable.addListener(14, new Listener(){

            public final void handleEvent(Event event) {
                QuickMenuDialog.this.select();
            }
        });
        this.fTable.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (!e.doit) {
                    return;
                }
                int index = QuickMenuDialog.MNEMONICS.indexOf(e.character);
                if (index != -1 && index < QuickMenuDialog.this.fTable.getItemCount()) {
                    e.doit = false;
                    int returnCode = index;
                    TableItem[] tableItemArray = QuickMenuDialog.this.fTable.getItems();
                    int n = tableItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Integer value;
                        TableItem item = tableItemArray[n2];
                        Object data = item.getData(QuickMenuDialog.MNEMONIC);
                        if (data instanceof Integer && (value = (Integer)data) == index) {
                            returnCode = (Integer)item.getData(QuickMenuDialog.INDEX);
                            break;
                        }
                        ++n2;
                    }
                    QuickMenuDialog.this.setReturnCode(returnCode);
                    QuickMenuDialog.this.close();
                }
            }
        });
        this.fTable.addListener(40, new Listener(){

            public void handleEvent(Event event) {
                TableItem item;
                if ((event.detail & 2) != 0 && QuickMenuDialog.this.isSeparator(item = (TableItem)event.item)) {
                    event.detail &= 0xFFFFFFFD;
                    event.detail &= 0xFFFFFFF7;
                }
            }
        });
        this.fTable.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                int selectionIndex = QuickMenuDialog.this.fTable.getSelectionIndex();
                final int initialIndex = selectionIndex++;
                if (e.detail == 64) {
                    while (QuickMenuDialog.this.isSeparator(QuickMenuDialog.this.fTable.getItem(selectionIndex))) {
                        if (++selectionIndex < QuickMenuDialog.this.fTable.getItemCount()) continue;
                        return;
                    }
                    --selectionIndex;
                } else if (e.detail == 32) {
                    --selectionIndex;
                    while (QuickMenuDialog.this.isSeparator(QuickMenuDialog.this.fTable.getItem(selectionIndex))) {
                        if (--selectionIndex >= 0) continue;
                        new UIJob("retaining selection"){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                QuickMenuDialog.this.fTable.setSelection(initialIndex);
                                return Status.OK_STATUS;
                            }
                        }.schedule();
                        e.doit = false;
                        return;
                    }
                    ++selectionIndex;
                } else {
                    return;
                }
                if (selectionIndex < QuickMenuDialog.this.fTable.getItemCount() && selectionIndex >= 0) {
                    QuickMenuDialog.this.fTable.setSelection(selectionIndex);
                    e.doit = false;
                }
            }
        });
    }

    protected boolean isSeparator(TableItem item) {
        Object obj = item.getData(IS_SEPARATOR);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return false;
    }

    protected void insertSeparator(int columns) {
        TableItem item = new TableItem(this.fTable, 0);
        int i = 0;
        while (i < columns) {
            TableEditor editor = new TableEditor(this.fTable);
            Label label = new Label((Composite)this.fTable, 258);
            editor.grabHorizontal = true;
            editor.setEditor((Control)label, item, i);
            ++i;
        }
        item.setData(IS_SEPARATOR, (Object)true);
    }

    protected void select() {
        int index = this.fTable.getSelectionIndex();
        TableItem item = this.fTable.getItem(index);
        int returnCode = (Integer)item.getData(INDEX);
        this.setReturnCode(returnCode);
        this.close();
    }

    public int open() {
        this.setReturnCode(-1);
        this.setBlockOnOpen(true);
        super.open();
        this.runEventLoop(this.getShell());
        return this.getReturnCode();
    }

    protected void handleShellCloseEvent() {
        super.handleShellCloseEvent();
        this.setReturnCode(-1);
    }

    private void runEventLoop(Shell loopShell) {
        Display display = loopShell.getDisplay();
        while (!loopShell.isDisposed()) {
            try {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!display.isDisposed()) {
            display.update();
        }
    }
}

